<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta content='width=device-width, initial-scale=1, maximum-scale=1' name='viewport'/>
    
    <meta http-equiv="X-UA-Compatible" content-area="IE=edge">
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <link rel="profile" href="http://gmpg.org/xfn/11" />
    <title><?php wp_title( '-', true, 'right' ); ?></title>
	<?php if(get_theme_mod('ct_favicon')) : ?>
	<link rel="shortcut icon" href="<?php echo get_theme_mod('ct_favicon'); ?>" />
	<?php endif; ?>
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
    <link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS Feed" href="<?php bloginfo('rss2_url'); ?>" />
    <link rel="alternate" type="application/atom+xml" title="<?php bloginfo('name'); ?> Atom Feed" href="<?php bloginfo('atom_url'); ?>" />
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<div id="top-area">
		<div class="top-area-content container">
			<div id="navigation-wrap">
				<?php wp_nav_menu( array( 'container' => false, 'theme_location' => 'mainpage-menu', 'menu_class' => 'menu' ) ); ?>
			</div>
			<div class="menu-mobile"></div>
			<?php if(!get_theme_mod('ct_topbar_search_check')) : ?>
			<div id="upper-search-area">
				<a href="#" class="ct_icon search"><i class="fa fa-search"></i></a>
				<div class="display-search-view">
					<?php get_search_form(); ?>
				</div>
			</div>
			<?php endif; ?>
			
			<?php if(!get_theme_mod('ct_topbar_social_check')) : ?>
			<div id="upper-social-area" <?php if(get_theme_mod('ct_topbar_search_check')) : ?>class="nosearch"<?php endif; ?>>
			
				<?php if(get_theme_mod('ct_facebook')) : ?><a href="http://facebook.com/<?php echo esc_html(get_theme_mod('ct_facebook')); ?>" target="_blank"><i class="fa fa-facebook"></i></a><?php endif; ?>
				<?php if(get_theme_mod('ct_twitter')) : ?><a href="http://twitter.com/<?php echo esc_html(get_theme_mod('ct_twitter')); ?>" target="_blank"><i class="fa fa-twitter"></i></a><?php endif; ?>
				<?php if(get_theme_mod('ct_instagram')) : ?><a href="http://instagram.com/<?php echo esc_html(get_theme_mod('ct_instagram')); ?>" target="_blank"><i class="fa fa-instagram"></i></a><?php endif; ?>
				<?php if(get_theme_mod('ct_pinterest')) : ?><a href="http://pinterest.com/<?php echo esc_html(get_theme_mod('ct_pinterest')); ?>" target="_blank"><i class="fa fa-pinterest"></i></a><?php endif; ?>
				<?php if(get_theme_mod('ct_bloglovin')) : ?><a href="http://bloglovin.com/<?php echo esc_html(get_theme_mod('ct_bloglovin')); ?>" target="_blank"><i class="fa fa-heart"></i></a><?php endif; ?>
				<?php if(get_theme_mod('ct_google')) : ?><a href="http://plus.google.com/<?php echo esc_html(get_theme_mod('ct_google')); ?>" target="_blank"><i class="fa fa-google-plus"></i></a><?php endif; ?>
				<?php if(get_theme_mod('ct_tumblr')) : ?><a href="http://<?php echo esc_html(get_theme_mod('ct_tumblr')); ?>.tumblr.com/" target="_blank"><i class="fa fa-tumblr"></i></a><?php endif; ?>
				<?php if(get_theme_mod('ct_youtube')) : ?><a href="http://youtube.com/<?php echo esc_html(get_theme_mod('ct_youtube')); ?>" target="_blank"><i class="fa fa-youtube-play"></i></a><?php endif; ?>
				<?php if(get_theme_mod('ct_dribbble')) : ?><a href="http://dribbble.com/<?php echo esc_html(get_theme_mod('ct_dribbble')); ?>" target="_blank"><i class="fa fa-dribbble"></i></a><?php endif; ?>
				<?php if(get_theme_mod('ct_soundcloud')) : ?><a href="http://soundcloud.com/<?php echo esc_html(get_theme_mod('ct_soundcloud')); ?>" target="_blank"><i class="fa fa-soundcloud"></i></a><?php endif; ?>
				<?php if(get_theme_mod('ct_vimeo')) : ?><a href="http://vimeo.com/<?php echo esc_html(get_theme_mod('ct_vimeo')); ?>" target="_blank"><i class="fa fa-vimeo-square"></i></a><?php endif; ?>
				<?php if(get_theme_mod('ct_linkedin')) : ?><a href="<?php echo esc_html(get_theme_mod('ct_linkedin')); ?>" target="_blank"><i class="fa fa-linkedin"></i></a><?php endif; ?>
				<?php if(get_theme_mod('ct_rss')) : ?><a href="<?php echo esc_url(get_theme_mod('ct_rss')); ?>" target="_blank"><i class="fa fa-rss"></i></a><?php endif; ?>
				
			</div>
			<?php endif ;?>
			
		</div>
		
	</div>
	
	<header id="header" <?php if(!get_theme_mod('chick_themes_slider')) : ?>class="missing_slider"<?php endif; ?>>
		
		<div class="frontclass container">
			
			<div id="logo">
				
				<?php if(!get_theme_mod('ct_logo')) : ?>
					
					<?php if(is_front_page()) : ?>
                        <h1>
                            <a href="<?php echo esc_url( home_url('/') ); ?>"><?php bloginfo('name'); ?></a></h1>
                        <span><?php bloginfo( 'description' ) ?></span>
					<?php else : ?>
                        <h2>
                            <a href="<?php echo esc_url( home_url('/') ); ?>"><?php bloginfo('name'); ?></a></h2>
                        <span><?php bloginfo( 'description' ) ?></span>
					<?php endif; ?>
					
				<?php else : ?>
					
					<?php if(is_front_page()) : ?>
						<h1><a href="<?php echo home_url(); ?>"><img src="<?php echo esc_url(get_theme_mod('ct_logo')); ?>" alt="<?php bloginfo( 'name' ); ?>" /></a></h1>
					<?php else : ?>
						<h2><a href="<?php echo home_url(); ?>"><img src="<?php echo esc_url(get_theme_mod('ct_logo')); ?>" alt="<?php bloginfo( 'name' ); ?>" /></a></h2>
					<?php endif; ?>
					
				<?php endif; ?>
				
			</div>
			
		</div>
		
	</header>